goog.provide('com.wsscode.edn_LT___GT_json');
goog.require('cljs.core');
goog.require('clojure.edn');
goog.require('cljs.spec.alpha');
goog.require('clojure.string');
goog.require('goog.object');
cljs.spec.alpha.def_impl.call(null,new cljs.core.Keyword("com.wsscode.edn<->json","encode-list-type?","com.wsscode.edn<->json/encode-list-type?",-1520761029),new cljs.core.Symbol("cljs.core","boolean?","cljs.core/boolean?",1400713761,null),cljs.core.boolean_QMARK_);
/**
 * Return true for simple JS types. The intended use of this function is to detect if
 *   a value should be stored in its original form, for values that return false here, its
 *   expected that they get some encoding process before ending up as a JS value.
 */
com.wsscode.edn_LT___GT_json.simple_js_type_QMARK_ = (function com$wsscode$edn_LT___GT_json$simple_js_type_QMARK_(x){
return ((typeof x === 'string') || (typeof x === 'number') || (cljs.core.boolean_QMARK_.call(null,x)) || ((x == null)) || ((void 0 === x)));
});
com.wsscode.edn_LT___GT_json.encode_key = (function com$wsscode$edn_LT___GT_json$encode_key(x){
if((((x instanceof cljs.core.Keyword)) || (typeof x === 'number') || (typeof x === 'string'))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
} else {
return ["__edn-key|",cljs.core.pr_str.call(null,x)].join('');

}
});
com.wsscode.edn_LT___GT_json.decode_key = (function com$wsscode$edn_LT___GT_json$decode_key(s){
if(clojure.string.starts_with_QMARK_.call(null,s,":")){
return cljs.core.keyword.call(null,cljs.core.subs.call(null,s,(1)));
} else {
if(clojure.string.starts_with_QMARK_.call(null,s,"__edn-key|")){
return clojure.edn.read_string.call(null,cljs.core.subs.call(null,s,(("__edn-key|").length)));
} else {
return s;

}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * 
 *   The encoded JSON will have extra notation to enable a better deserialization
 *   later, keeping complex keys, keyword keys (simple and qualified), also encode
 *   extended types like UUID and dates. Using json->edn you can restore the original
 *   data from the JSON.
 * 
 *   Some things that don't get restored:
 * 
 *   - metadata is lost
 *   - number keys on maps will be turned into strings on the conversion back
 * 
 *   Other than that, all printable values should encode and decode with fidelity.
 */
com.wsscode.edn_LT___GT_json.edn__GT_json = (function com$wsscode$edn_LT___GT_json$edn__GT_json(var_args){
var G__44524 = arguments.length;
switch (G__44524) {
case 1:
return com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_LT___GT_json.edn__GT_json.call(null,x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$core$IFn$_invoke$arity$2 = (function (x,p__44525){
var map__44526 = p__44525;
var map__44526__$1 = (((((!((map__44526 == null))))?(((((map__44526.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44526.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44526):map__44526);
var encode_list_type_QMARK_ = cljs.core.get.call(null,map__44526__$1,new cljs.core.Keyword("com.wsscode.edn<->json","encode-list-type?","com.wsscode.edn<->json/encode-list-type?",-1520761029),true);
var thisfn = (function com$wsscode$edn_LT___GT_json$thisfn(x__$1){
if(com.wsscode.edn_LT___GT_json.simple_js_type_QMARK_.call(null,x__$1)){
return x__$1;
} else {
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeJS$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeJS,x__$1))){
return cljs.core._clj__GT_js.call(null,x__$1);
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
var m = ({});
var seq__44554_44599 = cljs.core.seq.call(null,x__$1);
var chunk__44555_44600 = null;
var count__44556_44601 = (0);
var i__44557_44602 = (0);
while(true){
if((i__44557_44602 < count__44556_44601)){
var vec__44564_44603 = cljs.core._nth.call(null,chunk__44555_44600,i__44557_44602);
var k_44604 = cljs.core.nth.call(null,vec__44564_44603,(0),null);
var v_44605 = cljs.core.nth.call(null,vec__44564_44603,(1),null);
goog.object.set(m,com.wsscode.edn_LT___GT_json.encode_key.call(null,k_44604),com$wsscode$edn_LT___GT_json$thisfn.call(null,v_44605));


var G__44606 = seq__44554_44599;
var G__44607 = chunk__44555_44600;
var G__44608 = count__44556_44601;
var G__44609 = (i__44557_44602 + (1));
seq__44554_44599 = G__44606;
chunk__44555_44600 = G__44607;
count__44556_44601 = G__44608;
i__44557_44602 = G__44609;
continue;
} else {
var temp__5735__auto___44610 = cljs.core.seq.call(null,seq__44554_44599);
if(temp__5735__auto___44610){
var seq__44554_44611__$1 = temp__5735__auto___44610;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44554_44611__$1)){
var c__4609__auto___44612 = cljs.core.chunk_first.call(null,seq__44554_44611__$1);
var G__44613 = cljs.core.chunk_rest.call(null,seq__44554_44611__$1);
var G__44614 = c__4609__auto___44612;
var G__44615 = cljs.core.count.call(null,c__4609__auto___44612);
var G__44616 = (0);
seq__44554_44599 = G__44613;
chunk__44555_44600 = G__44614;
count__44556_44601 = G__44615;
i__44557_44602 = G__44616;
continue;
} else {
var vec__44567_44617 = cljs.core.first.call(null,seq__44554_44611__$1);
var k_44618 = cljs.core.nth.call(null,vec__44567_44617,(0),null);
var v_44619 = cljs.core.nth.call(null,vec__44567_44617,(1),null);
goog.object.set(m,com.wsscode.edn_LT___GT_json.encode_key.call(null,k_44618),com$wsscode$edn_LT___GT_json$thisfn.call(null,v_44619));


var G__44620 = cljs.core.next.call(null,seq__44554_44611__$1);
var G__44621 = null;
var G__44622 = (0);
var G__44623 = (0);
seq__44554_44599 = G__44620;
chunk__44555_44600 = G__44621;
count__44556_44601 = G__44622;
i__44557_44602 = G__44623;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var arr = [];
if(cljs.core.truth_(encode_list_type_QMARK_)){
if(cljs.core.set_QMARK_.call(null,x__$1)){
arr.push("__edn-list-type|set");
} else {
if(cljs.core.list_QMARK_.call(null,x__$1)){
arr.push("__edn-list-type|list");
} else {
}
}
} else {
}

var seq__44570_44624 = cljs.core.seq.call(null,cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn,x__$1));
var chunk__44571_44625 = null;
var count__44572_44626 = (0);
var i__44573_44627 = (0);
while(true){
if((i__44573_44627 < count__44572_44626)){
var x_44628__$2 = cljs.core._nth.call(null,chunk__44571_44625,i__44573_44627);
arr.push(x_44628__$2);


var G__44629 = seq__44570_44624;
var G__44630 = chunk__44571_44625;
var G__44631 = count__44572_44626;
var G__44632 = (i__44573_44627 + (1));
seq__44570_44624 = G__44629;
chunk__44571_44625 = G__44630;
count__44572_44626 = G__44631;
i__44573_44627 = G__44632;
continue;
} else {
var temp__5735__auto___44633 = cljs.core.seq.call(null,seq__44570_44624);
if(temp__5735__auto___44633){
var seq__44570_44634__$1 = temp__5735__auto___44633;
if(cljs.core.chunked_seq_QMARK_.call(null,seq__44570_44634__$1)){
var c__4609__auto___44635 = cljs.core.chunk_first.call(null,seq__44570_44634__$1);
var G__44636 = cljs.core.chunk_rest.call(null,seq__44570_44634__$1);
var G__44637 = c__4609__auto___44635;
var G__44638 = cljs.core.count.call(null,c__4609__auto___44635);
var G__44639 = (0);
seq__44570_44624 = G__44636;
chunk__44571_44625 = G__44637;
count__44572_44626 = G__44638;
i__44573_44627 = G__44639;
continue;
} else {
var x_44640__$2 = cljs.core.first.call(null,seq__44570_44634__$1);
arr.push(x_44640__$2);


var G__44641 = cljs.core.next.call(null,seq__44570_44634__$1);
var G__44642 = null;
var G__44643 = (0);
var G__44644 = (0);
seq__44570_44624 = G__44641;
chunk__44571_44625 = G__44642;
count__44572_44626 = G__44643;
i__44573_44627 = G__44644;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return ["__edn-value|",cljs.core.pr_str.call(null,x__$1)].join('');

}
}
}
}
});
return thisfn.call(null,x);
}));

(com.wsscode.edn_LT___GT_json.edn__GT_json.cljs$lang$maxFixedArity = 2);

/**
 * Same as edn->json, but returns Clojure maps that are JSON friendly instead of the
 *   JSON directly. This is useful as a middle format if you need to later send it encoded
 *   as JSON.
 */
com.wsscode.edn_LT___GT_json.edn__GT_json_like = (function com$wsscode$edn_LT___GT_json$edn__GT_json_like(var_args){
var G__44575 = arguments.length;
switch (G__44575) {
case 1:
return com.wsscode.edn_LT___GT_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_LT___GT_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_LT___GT_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_LT___GT_json.edn__GT_json_like.call(null,x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_LT___GT_json.edn__GT_json_like.cljs$core$IFn$_invoke$arity$2 = (function (x,p__44576){
var map__44577 = p__44576;
var map__44577__$1 = (((((!((map__44577 == null))))?(((((map__44577.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__44577.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.call(null,cljs.core.hash_map,map__44577):map__44577);
var encode_list_type_QMARK_ = cljs.core.get.call(null,map__44577__$1,new cljs.core.Keyword("com.wsscode.edn<->json","encode-list-type?","com.wsscode.edn<->json/encode-list-type?",-1520761029),true);
var thisfn = (function com$wsscode$edn_LT___GT_json$thisfn(x__$1){
if(com.wsscode.edn_LT___GT_json.simple_js_type_QMARK_.call(null,x__$1)){
return x__$1;
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
return cljs.core.into.call(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.call(null,(function (p__44584){
var vec__44585 = p__44584;
var k = cljs.core.nth.call(null,vec__44585,(0),null);
var v = cljs.core.nth.call(null,vec__44585,(1),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [com.wsscode.edn_LT___GT_json.encode_key.call(null,k),com$wsscode$edn_LT___GT_json$thisfn.call(null,v)], null);
})),x__$1);
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var arr = (cljs.core.truth_(encode_list_type_QMARK_)?(function (){var G__44588 = cljs.core.PersistentVector.EMPTY;
var G__44588__$1 = ((cljs.core.set_QMARK_.call(null,x__$1))?cljs.core.conj.call(null,G__44588,"__edn-list-type|set"):G__44588);
if(cljs.core.list_QMARK_.call(null,x__$1)){
return cljs.core.conj.call(null,G__44588__$1,"__edn-list-type|list");
} else {
return G__44588__$1;
}
})():cljs.core.PersistentVector.EMPTY);
return cljs.core.into.call(null,arr,cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn),x__$1);
} else {
return ["__edn-value|",cljs.core.pr_str.call(null,x__$1)].join('');

}
}
}
});
return thisfn.call(null,x);
}));

(com.wsscode.edn_LT___GT_json.edn__GT_json_like.cljs$lang$maxFixedArity = 2);

com.wsscode.edn_LT___GT_json.js_obj_QMARK_ = (function com$wsscode$edn_LT___GT_json$js_obj_QMARK_(x){
return (cljs.core.type.call(null,x) === Object);
});
com.wsscode.edn_LT___GT_json.list_type_STAR_ = (function com$wsscode$edn_LT___GT_json$list_type_STAR_(x){
if(typeof x === 'string'){
if(clojure.string.starts_with_QMARK_.call(null,x,"__edn-list-type|")){
return cljs.core.subs.call(null,x,(("__edn-list-type|").length));
} else {
return false;
}
} else {
return false;
}
});
com.wsscode.edn_LT___GT_json.list_type = (function com$wsscode$edn_LT___GT_json$list_type(x){
var f = (x[(0)]);
return com.wsscode.edn_LT___GT_json.list_type_STAR_.call(null,f);
});
/**
 * Recursively transforms JavaScript arrays into ClojureScript
 *   vectors, and JavaScript objects into ClojureScript maps.
 * 
 *   Use to get fidelity restore of JSON data encoded with edn->json.
 */
com.wsscode.edn_LT___GT_json.json__GT_edn = (function com$wsscode$edn_LT___GT_json$json__GT_edn(var_args){
var G__44590 = arguments.length;
switch (G__44590) {
case 1:
return com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_LT___GT_json.json__GT_edn.call(null,x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$core$IFn$_invoke$arity$2 = (function (x,opts){
var f = (function com$wsscode$edn_LT___GT_json$thisfn(x__$1){
if((((!((x__$1 == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === x__$1.cljs$core$IEncodeClojure$))))?true:(((!x__$1.cljs$lang$protocol_mask$partition$))?cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeClojure,x__$1):false)):cljs.core.native_satisfies_QMARK_.call(null,cljs.core.IEncodeClojure,x__$1))){
return cljs.core._js__GT_clj.call(null,x__$1,cljs.core.apply.call(null,cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_.call(null,x__$1)){
return cljs.core.doall.call(null,cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn,x__$1));
} else {
if(cljs.core.map_entry_QMARK_.call(null,x__$1)){
return (new cljs.core.MapEntry(com$wsscode$edn_LT___GT_json$thisfn.call(null,cljs.core.key.call(null,x__$1)),com$wsscode$edn_LT___GT_json$thisfn.call(null,cljs.core.val.call(null,x__$1)),null));
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
return cljs.core.into.call(null,cljs.core.empty.call(null,x__$1),cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn),x__$1);
} else {
if(cljs.core.array_QMARK_.call(null,x__$1)){
var lt = com.wsscode.edn_LT___GT_json.list_type.call(null,x__$1);
return cljs.core.into.call(null,(function (){var G__44592 = lt;
switch (G__44592) {
case "list":
return cljs.core.List.EMPTY;

break;
case "set":
return cljs.core.PersistentHashSet.EMPTY;

break;
default:
return cljs.core.PersistentVector.EMPTY;

}
})(),cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn),(function (){var G__44593 = cljs.core.array_seq.call(null,x__$1);
var G__44593__$1 = (cljs.core.truth_(lt)?cljs.core.drop.call(null,(1),G__44593):G__44593);
if(cljs.core._EQ_.call(null,lt,"list")){
return cljs.core.reverse.call(null,G__44593__$1);
} else {
return G__44593__$1;
}
})());
} else {
if(((typeof x__$1 === 'string') && (clojure.string.starts_with_QMARK_.call(null,x__$1,"__edn-value|")))){
return clojure.edn.read_string.call(null,cljs.core.subs.call(null,x__$1,(("__edn-value|").length)));
} else {
if((cljs.core.type.call(null,x__$1) === Object)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (r,k){
return cljs.core.assoc_BANG_.call(null,r,com.wsscode.edn_LT___GT_json.decode_key.call(null,k),com$wsscode$edn_LT___GT_json$thisfn.call(null,goog.object.get(x__$1,k)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.js_keys.call(null,x__$1)));
} else {
return x__$1;

}
}
}
}
}
}
}
});
return f.call(null,x);
}));

(com.wsscode.edn_LT___GT_json.json__GT_edn.cljs$lang$maxFixedArity = 2);

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 *   vectors, and JavaScript objects into ClojureScript maps.
 * 
 *   Use to get fidelity restore of JSON data encoded with edn->json.
 */
com.wsscode.edn_LT___GT_json.json_like__GT_edn = (function com$wsscode$edn_LT___GT_json$json_like__GT_edn(var_args){
var G__44595 = arguments.length;
switch (G__44595) {
case 1:
return com.wsscode.edn_LT___GT_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return com.wsscode.edn_LT___GT_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(com.wsscode.edn_LT___GT_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$1 = (function (x){
return com.wsscode.edn_LT___GT_json.json_like__GT_edn.call(null,x,cljs.core.PersistentArrayMap.EMPTY);
}));

(com.wsscode.edn_LT___GT_json.json_like__GT_edn.cljs$core$IFn$_invoke$arity$2 = (function (x,opts){
var f = (function com$wsscode$edn_LT___GT_json$thisfn(x__$1){
if(cljs.core.seq_QMARK_.call(null,x__$1)){
return cljs.core.doall.call(null,cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn,x__$1));
} else {
if(cljs.core.map_QMARK_.call(null,x__$1)){
return cljs.core.persistent_BANG_.call(null,cljs.core.reduce.call(null,(function (r,k){
return cljs.core.assoc_BANG_.call(null,r,com.wsscode.edn_LT___GT_json.decode_key.call(null,k),com$wsscode$edn_LT___GT_json$thisfn.call(null,cljs.core.get.call(null,x__$1,k)));
}),cljs.core.transient$.call(null,cljs.core.PersistentArrayMap.EMPTY),cljs.core.keys.call(null,x__$1)));
} else {
if(cljs.core.coll_QMARK_.call(null,x__$1)){
var lt = com.wsscode.edn_LT___GT_json.list_type_STAR_.call(null,cljs.core.first.call(null,x__$1));
return cljs.core.into.call(null,(function (){var G__44596 = lt;
switch (G__44596) {
case "list":
return cljs.core.List.EMPTY;

break;
case "set":
return cljs.core.PersistentHashSet.EMPTY;

break;
default:
return cljs.core.PersistentVector.EMPTY;

}
})(),cljs.core.map.call(null,com$wsscode$edn_LT___GT_json$thisfn),(function (){var G__44597 = x__$1;
var G__44597__$1 = (cljs.core.truth_(lt)?cljs.core.drop.call(null,(1),G__44597):G__44597);
if(cljs.core._EQ_.call(null,lt,"list")){
return cljs.core.reverse.call(null,G__44597__$1);
} else {
return G__44597__$1;
}
})());
} else {
if(((typeof x__$1 === 'string') && (clojure.string.starts_with_QMARK_.call(null,x__$1,"__edn-value|")))){
return clojure.edn.read_string.call(null,cljs.core.subs.call(null,x__$1,(("__edn-value|").length)));
} else {
return x__$1;

}
}
}
}
});
return f.call(null,x);
}));

(com.wsscode.edn_LT___GT_json.json_like__GT_edn.cljs$lang$maxFixedArity = 2);


//# sourceMappingURL=com.wsscode.edn<_>json.js.map
